package test.ru.workerissue

import android.app.Application
import android.util.Log
import androidx.work.*
import java.util.concurrent.TimeUnit

class App : Application() {

    private val tag = "WORKER_TAG"
    private val BACKOFF_DELAY_SECONDS = 60L

    override fun onCreate() {
        super.onCreate()
        initWorker()
    }

    private fun initWorker() {
        WorkManager.initialize(this, Configuration.Builder().setMinimumLoggingLevel(2).build())

        val workManager = WorkManager.getInstance()
        val workRequest = OneTimeWorkRequest.Builder(TestWorker::class.java)
            .setConstraints(
                Constraints
                    .Builder()
                    .setRequiredNetworkType(NetworkType.CONNECTED)
                    .build()
            )
            .setBackoffCriteria(
                BackoffPolicy.EXPONENTIAL,
                BACKOFF_DELAY_SECONDS,
                TimeUnit.SECONDS
            )
            .addTag(tag)
            .build()

        workManager.cancelAllWorkByTag(tag)
        workManager.enqueue(workRequest)
    }
}